HOG_ButtonFont = {
  standardFont,
  18,
  WhiteColor
};
FooterGraphics = {
	"HiddenObject/UI/Button/oknormal",
	"HiddenObject/UI/Button/okdown",
	"HiddenObject/UI/Button/okover",
};	

FooterStyle= {
	type = kPush,
	font = HOG_ButtonFont,
	flags = kHAlignCenter + kVAlignCenter,
	graphics = FooterGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};


HOG_Graphics_Pause = {
	"HiddenObject/UI/Button/pausenormal",
	"HiddenObject/UI/Button/pausemousedown",
	"HiddenObject/UI/Button/pausemouseover"
};


HOG_Style_Pause = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = HOG_Graphics_Pause,
};

ResetButtonFont = {
  standardFont,
  22,
  StandardButtonTextColor 
};



ResetButtonFont_Disabled = {
  standardFont,
  22,
  BlackColor
};

HOG_Graphics_Reset = {
	"HiddenObject/UI/Button/resetnormal",
	"HiddenObject/UI/Button/resetdown",
	"HiddenObject/UI/Button/resetmouseover"
};


HOG_Style_Reset = {
	parent = DefaultStyle,
	font = ResetButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = HOG_Graphics_Reset,
};

HOG_Graphics_Hint = {
	"HiddenObject/UI/Button/hintnormal",
	"HiddenObject/UI/Button/hintmousedown",
	"HiddenObject/UI/Button/hintmouseover"
};
HOG_Graphics_Reset_Disabled = {
	"HiddenObject/UI/Button/resetnormal",
};


HOG_Style_Reset_Disabled = {
	parent = DefaultStyle,
	font = ResetButtonFont,
	sound = "HiddenObject/Audio/sfx/nothing.ogg",
	rolloversound = "HiddenObject/Audio/sfx/nothing.ogg",
	type= kPush,
	graphics = HOG_Graphics_Reset_Disabled,
};

HOG_Graphics_Hint = {
	"HiddenObject/UI/Button/hintnormal",
	"HiddenObject/UI/Button/hintmousedown",
	"HiddenObject/UI/Button/hintmouseover"
};

HOG_Style_Hint = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	type= kPush,
	graphics = HOG_Graphics_Hint,
};



FooterMenuButtonFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  16,
  WhiteColor
};

FooterMenuGraphics = {
	"HiddenObject/UI/Button/footerbuttonup",
	"HiddenObject/UI/Button/footerbuttondown",
	"HiddenObject/UI/Button/footerbuttonrollover"
};


FooterMenuStyle = {
	parent = DefaultStyle,
	font = FooterMenuButtonFont,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
	type= kPush,
	graphics = FooterMenuGraphics,
	flags = kVAlignCenter + kHAlignCenter,
};

MakeDialog
{
	name="thegame",			
		
	GameWindow
	{
		x=0,
		y=0,
		w=800,
		h=600,
		
		hint_x = 725.0,
		hint_y = 567.0,
		
		dataLeft = 270.0,
		valuesLeft = 465.0,
		dataWidth = 33.5,
		dataTop = 122.0,
		headerTop = 45.0,
		headerLeft = 300.0,
		
		headerSize = 34,
		dataSize = 30,

		headerColor = Color(131,167,184, 255),
		dataColor = Color(131,167,184, 255),
		valueColor = Color(204,198,183);
		shadowColor = Color(0,0,0, 255),
		
		alphaThreshold = 150;
		
		SetStyle(HOG_Graphics_Reset);		
		Button
		{
			x=420,
			y=516,
			font = ResetButtonFont,
			graphics = HOG_Graphics_Reset,
			name="reset",
			label="reset",
			sound = kDefaultButtonSound,
			rolloversound = kDefaultButtonOverSound,
			type = kPush,
			command=
				function()
					SendGameMessage("resetgame_trigger");					
				end
		},
		
		
		SetStyle(HOG_Graphics_Reset_Disabled);		
		Button
		{
			x=420,
			y=516,
			font = ResetButtonFont_Disabled,
			graphics = HOG_Graphics_Reset_Disabled,
			name="reset_Disabled",
			label="reset",
			--sound = null,
			--rolloversound = kDefaultButtonOverSound,
			type = kPush,
			command=
				function()
				end
		},
		
		
		SetStyle(HOG_Graphics_Pause);		
		Button
		{
			x=23,
			y=543,
			font = StandardButtonFont,
			graphics = HOG_Graphics_Pause,
			name="pause",
			label="pause",
			sound = kDefaultButtonSound,
			rolloversound = kDefaultButtonOverSound,
			type = kPush,
			command=
				function()
					SendGameMessage("unpause");
					SendGameMessage("pause");
					--DoModal("HiddenObject/script/pause.lua");
				end
		},
		
		SetStyle(FooterStyle);
		Button
		{
			x=254,
			y=400,
			font = StandardButtonFont,
			name="ok",
			label="ok",
			sound = kDefaultButtonSound,
			rolloversound = kDefaultButtonOverSound,
			type = kPush,
			command=
				function()
					SendGameMessage("next");
					EnableWindow("reset_Disabled", false);
					EnableWindow("ok", false);
				end
		},

	},
}

EnableWindow("ok", false);
EnableWindow("reset", false);
EnableWindow("reset_Disabled", false);